// counter for the number of button presses
int buttonPushCounter = 0;
// current state of the button
int buttonState = 0;
//previous state of the button
int lastButtonState = 0;

void setup() {
  pinMode(LED_BUILTIN, OUTPUT);
  pinMode(8, INPUT);
  Serial.begin(9600);
}

// the loop function runs over and over again forever
void loop() {
  buttonState = digitalRead(8);
  if (buttonState != lastButtonState) {
    if (buttonState == HIGH) {
      buttonPushCounter++;
      Serial.println("I'm on! I was pushed " + String(buttonPushCounter) + " time/s");
      digitalWrite(LED_BUILTIN, HIGH);
    }
    else {
      Serial.println("I'm off!");
      digitalWrite(LED_BUILTIN, LOW);
    }
  }
  delay(50);
  lastButtonState = buttonState;
}
